VERSION 5.00
Begin VB.Form Form1 
   Caption         =   "AddressObject VB6 Sample"
   ClientHeight    =   8625
   ClientLeft      =   165
   ClientTop       =   555
   ClientWidth     =   13410
   LinkTopic       =   "Form1"
   ScaleHeight     =   8625
   ScaleWidth      =   13410
   StartUpPosition =   3  'Windows Default
   Begin VB.TextBox Results 
      BackColor       =   &H8000000F&
      ForeColor       =   &H00000000&
      Height          =   1095
      Left            =   7440
      MultiLine       =   -1  'True
      TabIndex        =   50
      Top             =   3960
      Width           =   4575
   End
   Begin VB.TextBox LastName 
      Height          =   375
      Left            =   1320
      TabIndex        =   49
      Top             =   3480
      Width           =   3855
   End
   Begin VB.TextBox output 
      BackColor       =   &H8000000F&
      Height          =   3015
      Left            =   6000
      Locked          =   -1  'True
      MultiLine       =   -1  'True
      ScrollBars      =   2  'Vertical
      TabIndex        =   47
      Top             =   5400
      Width           =   6015
   End
   Begin VB.CommandButton Command8 
      Caption         =   "Parse Last Line"
      Height          =   375
      Left            =   1320
      TabIndex        =   46
      Top             =   8040
      Width           =   2535
   End
   Begin VB.CommandButton Command7 
      Caption         =   "Parse"
      Height          =   375
      Left            =   1320
      TabIndex        =   45
      Top             =   6960
      Width           =   1215
   End
   Begin VB.CommandButton Command6 
      Caption         =   "Reparse"
      Height          =   375
      Left            =   2640
      TabIndex        =   44
      Top             =   6960
      Width           =   1215
   End
   Begin VB.TextBox LastLine 
      Height          =   375
      Left            =   1320
      TabIndex        =   43
      Top             =   7560
      Width           =   2535
   End
   Begin VB.TextBox pAddress 
      Height          =   375
      Left            =   1320
      TabIndex        =   42
      Top             =   6480
      Width           =   2535
   End
   Begin VB.CommandButton Command5 
      Caption         =   "Find Streets in Zip"
      Height          =   375
      Left            =   1320
      TabIndex        =   41
      Top             =   5400
      Width           =   2535
   End
   Begin VB.CommandButton Command4 
      Caption         =   "Find Zip"
      Height          =   375
      Left            =   1320
      TabIndex        =   40
      Top             =   5880
      Width           =   2535
   End
   Begin VB.CommandButton Command3 
      Caption         =   "Find Zips in City"
      Height          =   375
      Left            =   1320
      TabIndex        =   39
      Top             =   4920
      Width           =   2535
   End
   Begin VB.CommandButton Command2 
      Caption         =   "Find City in State"
      Height          =   375
      Left            =   1320
      TabIndex        =   38
      Top             =   4440
      Width           =   2535
   End
   Begin VB.CommandButton Command1 
      Caption         =   "Verify Address"
      Height          =   375
      Left            =   1320
      TabIndex        =   37
      Top             =   3960
      Width           =   2535
   End
   Begin VB.TextBox Suite 
      BackColor       =   &H8000000F&
      Height          =   375
      Left            =   7440
      Locked          =   -1  'True
      TabIndex        =   34
      Top             =   2520
      Width           =   4575
   End
   Begin VB.TextBox cPlus4 
      BackColor       =   &H8000000F&
      Height          =   375
      Left            =   11160
      Locked          =   -1  'True
      TabIndex        =   27
      Top             =   3480
      Width           =   855
   End
   Begin VB.TextBox cZip 
      BackColor       =   &H8000000F&
      Height          =   375
      Left            =   9840
      Locked          =   -1  'True
      TabIndex        =   26
      Top             =   3480
      Width           =   855
   End
   Begin VB.TextBox cState 
      BackColor       =   &H8000000F&
      Height          =   375
      Left            =   7440
      Locked          =   -1  'True
      TabIndex        =   25
      Top             =   3480
      Width           =   1095
   End
   Begin VB.TextBox cCity 
      BackColor       =   &H8000000F&
      Height          =   375
      Left            =   7440
      Locked          =   -1  'True
      TabIndex        =   24
      Top             =   3000
      Width           =   4575
   End
   Begin VB.TextBox cAddress2 
      BackColor       =   &H8000000F&
      Height          =   375
      Left            =   7440
      Locked          =   -1  'True
      TabIndex        =   23
      Top             =   2040
      Width           =   4575
   End
   Begin VB.TextBox cAddress 
      BackColor       =   &H8000000F&
      Height          =   375
      Left            =   7440
      Locked          =   -1  'True
      TabIndex        =   22
      Top             =   1560
      Width           =   4575
   End
   Begin VB.TextBox cCompany 
      BackColor       =   &H8000000F&
      Height          =   375
      Left            =   7440
      Locked          =   -1  'True
      TabIndex        =   21
      Top             =   1080
      Width           =   4575
   End
   Begin VB.TextBox Plus4 
      Height          =   375
      Left            =   4320
      TabIndex        =   14
      Top             =   3000
      Width           =   855
   End
   Begin VB.TextBox Zip 
      Height          =   375
      Left            =   2880
      TabIndex        =   13
      Top             =   3000
      Width           =   855
   End
   Begin VB.TextBox State 
      Height          =   375
      Left            =   1320
      TabIndex        =   12
      Top             =   3000
      Width           =   735
   End
   Begin VB.TextBox City 
      Height          =   375
      Left            =   1320
      TabIndex        =   11
      Top             =   2520
      Width           =   3855
   End
   Begin VB.TextBox Address2 
      Height          =   375
      Left            =   1320
      TabIndex        =   10
      Top             =   2040
      Width           =   3855
   End
   Begin VB.TextBox Address 
      Height          =   375
      Left            =   1320
      TabIndex        =   9
      Top             =   1560
      Width           =   3855
   End
   Begin VB.TextBox Company 
      Height          =   375
      Left            =   1320
      TabIndex        =   8
      Top             =   1080
      Width           =   3855
   End
   Begin VB.Label Label4 
      Caption         =   "Output Properties"
      Height          =   255
      Left            =   4560
      TabIndex        =   51
      Top             =   5400
      Width           =   1335
   End
   Begin VB.Label Label3 
      Caption         =   "Last Name"
      Height          =   255
      Left            =   360
      TabIndex        =   48
      Top             =   3480
      Width           =   855
   End
   Begin VB.Label Label21 
      Caption         =   "Results: "
      Height          =   255
      Left            =   6480
      TabIndex        =   36
      Top             =   3960
      Width           =   735
   End
   Begin VB.Label Label17 
      Caption         =   "Suite"
      Height          =   255
      Left            =   6480
      TabIndex        =   35
      Top             =   2520
      Width           =   615
   End
   Begin VB.Label Label8 
      Caption         =   "State"
      Height          =   255
      Left            =   360
      TabIndex        =   18
      Top             =   3000
      Width           =   615
   End
   Begin VB.Label Label16 
      Caption         =   "Zip"
      Height          =   255
      Left            =   9240
      TabIndex        =   33
      Top             =   3480
      Width           =   375
   End
   Begin VB.Label Label15 
      Caption         =   "-"
      Height          =   255
      Left            =   10920
      TabIndex        =   32
      Top             =   3480
      Width           =   255
   End
   Begin VB.Label Label14 
      Caption         =   "State"
      Height          =   255
      Left            =   6480
      TabIndex        =   31
      Top             =   3480
      Width           =   495
   End
   Begin VB.Label Label13 
      Caption         =   "City"
      Height          =   255
      Left            =   6480
      TabIndex        =   30
      Top             =   3000
      Width           =   615
   End
   Begin VB.Label Label12 
      Caption         =   "Address"
      Height          =   255
      Left            =   6480
      TabIndex        =   29
      Top             =   1560
      Width           =   735
   End
   Begin VB.Label Label11 
      Caption         =   "Company"
      Height          =   255
      Left            =   6480
      TabIndex        =   28
      Top             =   1080
      Width           =   735
   End
   Begin VB.Label Label10 
      Caption         =   "Zip"
      Height          =   255
      Left            =   2400
      TabIndex        =   20
      Top             =   3000
      Width           =   375
   End
   Begin VB.Label Label9 
      Caption         =   "-"
      Height          =   255
      Left            =   3840
      TabIndex        =   19
      Top             =   3000
      Width           =   255
   End
   Begin VB.Label Label7 
      Caption         =   "City"
      Height          =   255
      Left            =   360
      TabIndex        =   17
      Top             =   2520
      Width           =   615
   End
   Begin VB.Label Label6 
      Caption         =   "Address"
      Height          =   255
      Left            =   360
      TabIndex        =   16
      Top             =   1560
      Width           =   735
   End
   Begin VB.Label Label5 
      Caption         =   "Company"
      Height          =   255
      Left            =   360
      TabIndex        =   15
      Top             =   1080
      Width           =   735
   End
   Begin VB.Label InitErrorString 
      Height          =   255
      Left            =   9120
      TabIndex        =   7
      Top             =   240
      Width           =   3975
   End
   Begin VB.Label Label2 
      Caption         =   "Initialization Error: "
      ForeColor       =   &H8000000D&
      Height          =   255
      Left            =   7560
      TabIndex        =   6
      Top             =   240
      Width           =   1335
   End
   Begin VB.Label ExpDate 
      Height          =   255
      Left            =   6120
      TabIndex        =   5
      Top             =   240
      Width           =   1215
   End
   Begin VB.Label Label 
      Caption         =   "Expiration Date: "
      ForeColor       =   &H8000000D&
      Height          =   255
      Left            =   4800
      TabIndex        =   4
      Top             =   240
      Width           =   1215
   End
   Begin VB.Label DatabaseDate 
      Height          =   255
      Left            =   3480
      TabIndex        =   3
      Top             =   240
      Width           =   1215
   End
   Begin VB.Label Label1 
      Caption         =   "Database Date: "
      ForeColor       =   &H8000000D&
      Height          =   255
      Left            =   2160
      TabIndex        =   2
      Top             =   240
      Width           =   1215
   End
   Begin VB.Label BuildNum 
      Height          =   255
      Left            =   960
      TabIndex        =   1
      Top             =   240
      Width           =   975
   End
   Begin VB.Label Text 
      Caption         =   "Build: "
      ForeColor       =   &H8000000D&
      Height          =   255
      Left            =   240
      TabIndex        =   0
      Top             =   240
      Width           =   495
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False

'********************************************************************************
'If you should have any comments, suggestions or improvements to these samples,
'we welcome you to contact us at SampleCode@melissadata.com also please visit our
'developers bulletin board at forum.melissadata.com.
'********************************************************************************

    ' ********************** LICENSE STRINGS ***********************
    ' *     To unlock the full functionality of Address Object,    *
    ' * please call a sales representative at 1-800-MELISSA ext. 3 *
    ' *         (1-800-635-4772 x3) for a license string.          *
    ' *      Without a valid license string, AddressCheck will     *
    ' *                only verify Nevada addresses.               *
    ' *      REPLACE "DEMO" with LICENSE STRING                    *
    ' **************************************************************
    Const dLICENSE = "DEMO"
    ' ********************** DATA FILE PATH  ***********************
    ' File location path is set to the default Data File location. *
    ' Change this value if you installed the data files to a       *
    ' different folder.                                            *
    ' The Data Files Directory must contain the following files:   *
    ' mdAddr.dat, mdAddr.lic, mdAddr.nat, and mdAddr.str           *
    ' **************************************************************
    Const dFILELOC = "C:\\Program Files\\Melissa DATA\\DQT\\Data"
    
    Private addrObj As New ADDRESSOBJECTLib.AddressCheck
    Private parseObj As New ADDRESSOBJECTLib.Parse
    Private streetObj As New ADDRESSOBJECTLib.StreetData
    Private zipObj As New ADDRESSOBJECTLib.ZipCodeData
    Dim parseFlag As Integer
    Dim cBuff As String
    
Private Sub Form_Load()
        'Setting default Address information
        Company.Text = "ABC Company"
        Address.Text = "201 10th St."
        City.Text = "Las Vegas"
        State.Text = "NV"
        Zip.Text = "89101"
        pAddress.Text = "201 10th St."
        LastLine.Text = "Las Vegas, NV 89101-5519"
        parseFlag = 0
        output = ""
        
        'Calling to initialize Address Objects to license and datapaths
        Call initAddrObj
        Call initParseObj
        Call initStreetObj
        Call initZipObj

End Sub

Private Sub Command1_Click()
        Dim ResultsString As String
        Dim OutString As String
        OutString = ""
        'Clearing Properties from addrObj
        addrObj.ClearProperties
        
        'Loading values from Form into Object.
        addrObj.Company = Company.Text
        addrObj.Address = Address.Text
        addrObj.Address2 = Address2.Text
        addrObj.City = City.Text
        addrObj.State = State.Text
        addrObj.Plus4 = Plus4.Text
        addrObj.Zip = Zip.Text
        addrObj.LastName = LastName.Text

        'Verifying address.  Note: VerifyAddress() will return TRUE if successful.
        addrObj.VerifyAddress

        'Loading form with captured and corrected data.
        cCompany.Text = addrObj.Company
        cAddress.Text = addrObj.Address
        cAddress2.Text = addrObj.Address2
        Suite.Text = addrObj.Suite
        cCity.Text = addrObj.City
        cState.Text = addrObj.State
        cZip.Text = addrObj.Zip
        cPlus4.Text = addrObj.Plus4

        ' Parse the Results property
        ResultsString = addrObj.Results
        If ((InStr(1, ResultsString, "AS01")) Or (InStr(1, ResultsString, "AS02")) Or (InStr(1, ResultsString, "AS03"))) Then
            ' address was verified
            If (InStr(1, ResultsString, "AS01")) Then
                OutString = OutString + "AS01: Full Address Matched to Postal Database and is deliverable " + vbCrLf
            End If
            If (InStr(1, ResultsString, "AS02")) Then
                OutString = OutString + "AS02: Address matched to USPS database but a suite was missing Or invalid" + vbCrLf
            End If
            If (InStr(1, ResultsString, "AS03")) Then
              OutString = OutString + "AS03: Valid Physical Address, not Serviced by the USPS " + vbCrLf
            End If
            Results.ForeColor = &HC000&
        Else
            ' address could not be verified
            Results.ForeColor = &HC0&
        End If
        
        ' Display additional level of verification/comments
        
        If (InStr(1, ResultsString, "AS09")) Then
              OutString = OutString + "AS09: Foreign Postal Code Detected " + vbCrLf
        End If
        If (InStr(1, ResultsString, "AS10")) Then
              OutString = OutString + "AS10: Address Matched to CMRA" + vbCrLf
        End If
        If (InStr(1, ResultsString, "AS13")) Then
              OutString = OutString + "AS13: Address has been Updated by LACSLink " + vbCrLf
        End If
        If (InStr(1, ResultsString, "AS14")) Then
              OutString = OutString + "AS14: Suite Appended by SuiteLink " + vbCrLf
        End If
        If (InStr(1, ResultsString, "AS15")) Then
             OutString = OutString + "AS15: Suite Appended by SuiteFinder " + vbCrLf
        End If
        If (InStr(1, ResultsString, "AS16")) Then
              OutString = OutString + "AS16: Address is vacant." + vbCrLf
        End If
        If (InStr(1, ResultsString, "AS17")) Then
             OutString = OutString + "AS17: Alternate delivery." + vbCrLf
        End If
        If (InStr(1, ResultsString, "AS18")) Then
              OutString = OutString + "AS18: Artificially created adresses detected,DPV processing terminated at this point.  + vbCrLf"
        End If
        If (InStr(1, ResultsString, "AS20")) Then
              OutString = OutString + "AS20: Address Deliverable by USPS only " + vbCrLf
        End If
        If (InStr(1, ResultsString, "AS21")) Then
            OutString = OutString + "AS21: Alternate Address Suggestion Found" + vbCrLf
        End If
        If (InStr(1, ResultsString, "AS22")) Then
            OutString = OutString + "AS22: No Alternate Address Suggestion Found + vbCrLf"
        End If
        If (InStr(1, ResultsString, "AS23")) Then
            OutString = OutString + "AS23: Extraneous information found " + vbCrLf
        End If
        
        If (InStr(1, ResultsString, "AE")) Then
            ' there was an error in verifying the address
            If (InStr(1, ResultsString, "AE01")) Then
                  OutString = OutString + "AE01: Zip Code Error " + vbCrLf
            End If
            If (InStr(1, ResultsString, "AE02")) Then
                  OutString = OutString + "AE02: Unknown Street Error " + vbCrLf
            End If
            If (InStr(1, ResultsString, "AE03")) Then
                  OutString = OutString + "AE03: Component Mismatch Error " + vbCrLf
            End If
            If (InStr(1, ResultsString, "AE04")) Then
                  OutString = OutString + "AE04: Non-Deliverable Address Error " + vbCrLf
            End If
            If (InStr(1, ResultsString, "AE05")) Then
                  OutString = OutString + "AE05: Multiple Match Error " + vbCrLf
            End If
            If (InStr(1, ResultsString, "AE06")) Then
                  OutString = OutString + "AE06: Early Warning System Error " + vbCrLf
            End If
            If (InStr(1, ResultsString, "AE07")) Then
             OutString = OutString + "AE07: Missing Minimum Address Input " + vbCrLf
            End If
            If (InStr(1, ResultsString, "AE08")) Then
                  OutString = OutString + "AE08: Suite Range Invalid Error" + vbCrLf
            End If
            If (InStr(1, ResultsString, "AE09")) Then
                  OutString = OutString + "AE09: Suite Range Missing Error " + vbCrLf
            End If
            If (InStr(1, ResultsString, "AE10")) Then
                  OutString = OutString + "AE10: Primary Range Invalid Error " + vbCrLf
            End If
            If (InStr(1, ResultsString, "AE11")) Then
                  OutString = OutString + "AE11: Primary Range Missing Error " + vbCrLf
            End If
            If (InStr(1, ResultsString, "AE12")) Then
                  OutString = OutString + "AE12: PO, HC, or RR Box Number Invalid " + vbCrLf
            End If
            If (InStr(1, ResultsString, "AE13")) Then
                  OutString = OutString + "AE13: PO, HC, or RR Box Number Missing " + vbCrLf
            End If
            If (InStr(1, ResultsString, "AE14")) Then
                  OutString = OutString + "AE14: CMRA Secondary Missing Error" + vbCrLf
            End If
            
            ' program can not attempt address lookup
            If (InStr(1, ResultsString, "AE15")) Then
               OutString = OutString + "AE15: Demo Mode, valid license needed for full processing" + vbCrLf
            End If
            If (InStr(1, ResultsString, "AE16")) Then
                  OutString = OutString + "AE16: Expired Database, Update data files" + vbCrLf
            End If
            
            If (InStr(1, ResultsString, "AE17")) Then
                OutString = OutString + "AE17: Unnecessary Suite Error " + vbCrLf
            End If
            If (InStr(1, ResultsString, "AE19")) Then
                OutString = OutString + "AE19: Max time for FindSuggestion exceeded " + vbCrLf
            End If
            If (InStr(1, ResultsString, "AE20")) Then
                OutString = OutString + "AE20: FindSuggestion cannot be used" + vbCrLf
            End If
        End If
        
        ' a change was made to the address
        If (InStr(1, ResultsString, "AC01")) Then
            OutString = OutString + "AC01: ZIP Code Change " + vbCrLf
        End If
        If (InStr(1, ResultsString, "AC02")) Then
            OutString = OutString + "AC02: State Change" + vbCrLf
        End If
        If (InStr(1, ResultsString, "AC03")) Then
            OutString = OutString + "AC03: City Change" + vbCrLf
        End If
        If (InStr(1, ResultsString, "AC04")) Then
            OutString = OutString + "AC04: Base/Alternate Change" + vbCrLf
        End If
        If (InStr(1, ResultsString, "AC05")) Then
            OutString = OutString + "AC05: Alias Name Change" + vbCrLf
        End If
        If (InStr(1, ResultsString, "AC06")) Then
            OutString = OutString + "AC06: Address1/Address2 Swap" + vbCrLf
        End If
        If (InStr(1, ResultsString, "AC07")) Then
            OutString = OutString + "AC07: Address1/Company Swap" + vbCrLf
        End If
        If (InStr(1, ResultsString, "AC08")) Then
            OutString = OutString + "AC08: Plus4 Change" + vbCrLf
        End If
        If (InStr(1, ResultsString, "AC09")) Then
            OutString = OutString + "AC09: Urbanization Change" + vbCrLf
        End If
        If (InStr(1, ResultsString, "AC10")) Then
            OutString = OutString + "AC10: Street Name Change" + vbCrLf
        End If
        If (InStr(1, ResultsString, "AC11")) Then
            OutString = OutString + "AC11: Street Suffix Change" + vbCrLf
        End If
        If (InStr(1, ResultsString, "AC12")) Then
            OutString = OutString + "AC12: Street Directional Change" + vbCrLf
        End If
        If (InStr(1, ResultsString, "AC13")) Then
            OutString = OutString + "AC13: Suite Name Change" + vbCrLf
        End If
        
        Results.Text = OutString
        
        'Loading the comment text field with extra data and flags that are set when
        'the VerifyAddress Method is called.
        cBuff = "CarrierRoute=" + addrObj.CarrierRoute + vbCrLf
        cBuff = cBuff + "DeliveryPointCheckDigit=" + addrObj.DeliveryPointCheckDigit + vbCrLf
        cBuff = cBuff + "DeliveryPointCode=" + addrObj.DeliveryPointCode + vbCrLf
        cBuff = cBuff + "DPVFootnotes=" + addrObj.DPVFootnotes + vbCrLf
        cBuff = cBuff + vbCrLf
        cBuff = cBuff + "AddressTypeCode=" + addrObj.AddressTypeCode + vbNewLine
        cBuff = cBuff + "AddressTypeString=" + addrObj.AddressTypeString + vbNewLine
        cBuff = cBuff + "CityAbbreviation=" + addrObj.CityAbbreviation + vbCrLf
        cBuff = cBuff + "CountyName=" + addrObj.CountyName + vbCrLf
        cBuff = cBuff + "CountyFips=" + addrObj.CountyFips + vbCrLf
        cBuff = cBuff + "CountryCode=" + addrObj.CountryCode + vbCrLf
        cBuff = cBuff + "CongressionalDistrict=" + addrObj.CongressionalDistrict + vbCrLf
        cBuff = cBuff + "TimeZone=" + addrObj.TimeZone + vbCrLf
        cBuff = cBuff + "TimeZoneCode=" + addrObj.TimeZoneCode + vbCrLf
        cBuff = cBuff + "Urbanization=" + addrObj.Urbanization + vbCrLf
        cBuff = cBuff + "Zip=" + addrObj.Zip + vbCrLf
        cBuff = cBuff + "ZipType=" + addrObj.ZipType + vbCrLf
        cBuff = cBuff + vbCrLf
        cBuff = cBuff + "ParsedAddressRange=" + addrObj.ParsedAddressRange + vbCrLf
        cBuff = cBuff + "ParsedPreDirection=" + addrObj.ParsedPreDirection + vbCrLf
        cBuff = cBuff + "ParsedStreetName=" + addrObj.ParsedStreetName + vbCrLf
        cBuff = cBuff + "ParsedSuffix=" + addrObj.ParsedSuffix + vbCrLf
        cBuff = cBuff + "ParsedPostDirection=" + addrObj.ParsedPostDirection + vbCrLf
        cBuff = cBuff + "ParsedSuiteName=" + addrObj.ParsedSuiteName + vbCrLf
        cBuff = cBuff + "ParsedSuiteRange=" + addrObj.ParsedSuiteRange + vbCrLf
        cBuff = cBuff + "ParsedPrivateMailboxName=" + addrObj.ParsedPrivateMailboxName + vbCrLf
        cBuff = cBuff + "ParsedPrivateMailboxNumber=" + addrObj.ParsedPrivateMailboxNumber + vbCrLf
        cBuff = cBuff + "ParsedGarbage=" + addrObj.ParsedGarbage + vbCrLf
        cBuff = cBuff + vbCrLf
        cBuff = cBuff + "MSA=" + addrObj.Msa + vbCrLf
        cBuff = cBuff + "PMSA=" + addrObj.Pmsa + vbCrLf
        cBuff = cBuff + "CMRA=" + addrObj.CMRA + vbCrLf
        cBuff = cBuff + "PrivateMailbox=" + addrObj.PrivateMailbox + vbCrLf
        cBuff = cBuff + vbCrLf
        cBuff = cBuff + "ELotOrder=" + addrObj.ELotOrder + vbCrLf
        cBuff = cBuff + "ELotNumber=" + addrObj.ELotNumber + vbCrLf
        cBuff = cBuff + "LACS=" + addrObj.Lacs + vbCrLf
        cBuff = cBuff + "LACSLinkIndicator=" + addrObj.LACSLinkIndicator + vbCrLf
        cBuff = cBuff + "LACSLinkReturnCode=" + addrObj.LACSLinkReturnCode + vbCrLf
        cBuff = cBuff + "SuiteLinkReturnCode=" + addrObj.SuiteLinkReturnCode + vbCrLf
        cBuff = cBuff + "EWS=" + addrObj.EWSFlag + vbCrLf
        cBuff = cBuff + "RBDI=" + addrObj.RBDI + vbCrLf
        
        output.Text = cBuff
End Sub

Private Sub Command2_Click()
        'Call and test FindCityInState() to find first city in specified state.
        'FindCityInState() returns true if record is found.
        If zipObj.FindCityInState(City.Text, State.Text) Then
            'Successful.  Filling comment form with initial results.
            cBuff = zipObj.City + " " + zipObj.State + vbCrLf

            'Now will loop to try to find the next data.  Loop exits when FALSE.
            'FindCityinStateNext() returns TRUE if next record exists.
            While (zipObj.FindCityInStateNext())
                'Filling comment form with next result.
                cBuff = cBuff + zipObj.City + " " + zipObj.State + vbCrLf
            Wend
            output.Text = cBuff
        Else
            'Not successful, display warning.
            MsgBox ("Could Not Find City in State.")
        End If
End Sub

Private Sub Command3_Click()
        'Call and test ZipInCity() to find first zip code in specified city and state.
        'ZipInCity() returns true if record is found.
        If (zipObj.FindZipInCity(City.Text, State.Text)) Then
            'Successful.  Filling comment form with initial results.
            cBuff = ""
            Call printZipProperties

            'Now will loop to try to find the next data.  Loop exits when FALSE.
            'FindZipInCityNext() returns TRUE if next record exists.
            While (zipObj.FindZipInCityNext())
                'Filling comment form with next result.
                Call printZipProperties
            Wend
            output.Text = cBuff
        Else
            'Not successful, display warning.
            MsgBox ("Could Not Find Zip Code in City.")
        End If

End Sub

Private Sub Command4_Click()
         'Call and test FindZip() to find first zip code in specified city and state.
        'FindZip() returns true if record is found.
        If (zipObj.FindZip(Zip.Text, 0)) Then
            'Successful.  Creating header for output.
            'Filling comment form with initial results.
            cBuff = ""
            Call printZipProperties
            'Now will loop to try to find the next data.  Loop exits when FALSE.
            'FindZipNext() returns TRUE if next record exists.
            While (zipObj.FindZipNext())
                'Filling comment form with next result.
                cBuff = cBuff + zipObj.Zip + " "
                Call printZipProperties
            Wend
            output.Text = cBuff
        Else
            'Not successful, display notice.
            MsgBox ("Could Not Find Zip Code.")
        End If

End Sub

Private Sub Command5_Click()
  'Creating variable to hold only the parsed StreetName.
        Dim pStreet
        'Parsing Address value once to obtain only the Street Name and storing result.
        'Only necessary if user inputs full address line and not just street name.
        parseObj.Parse (Address.Text)
        'Storing parse to temp
        pStreet = parseObj.StreetName

        'Calling and testing FindStreet() to find the first street range found with input data.
        'FindStreet() Returns FALSE is no street record is found.
        If (streetObj.FindStreet(pStreet, Zip.Text, "0") = 0) Then
            'FindStreet() did not find the specified street in the zip code, show warning.
            'Check if your street in address is spelled correctly.  If you have reparsed manually, it may
            'have scrambled the input address so it would not be recognized by FindStreet().
            MsgBox ("Unable to locate specific Street Name in Zip Code. Recheck your Street Name in Address.")
        Else
            'Successful, recognized street and zip.
            'Filling and formating comment form with initial results.
            cBuff = ""
            Call printStreetProperties

            'Now will loop to try to find the next data.  Loop exits when FALSE.
            'FindStreetNext() returns TRUE if next record exists
            While (streetObj.FindStreetNext() > 0)
                'Filling comment form with next result.
                Call printStreetProperties
            Wend
        End If
        output.Text = cBuff
End Sub

Private Sub Command6_Click()
        'Calling ParseNext() to get all combinations of string tokens
        'Checking is parse() has been called already
        If (parseFlag = 1) Then
            'Checking if ParseNext() is available for new parse combo.
            If (parseObj.ParseNext()) Then
                'Success, get parsed information
                cBuff = ""
                Call printParseProperties
                output.Text = cBuff
            Else
                'End of parse combinations, display notice.
                MsgBox ("Finshed reparsing.")
            End If
        Else
            'Failed check, display warning.
            MsgBox ("Run Parse first.")
        End If
End Sub

Private Sub Command7_Click()
        'Calling Parse(), the first parsing of the address text from form
        'Must be run before ParseNext().
        parseObj.Parse (pAddress.Text)

        'Setting parseFlag to allow ParseNext() to be called
        parseFlag = 1
        'Print parsed data for form
        cBuff = ""
        Call printParseProperties
        output.Text = cBuff
End Sub

Private Sub Command8_Click()
        'Calling LastLineParse for inputed last line
        parseObj.LastLineParse (LastLine.Text)
        'Get data to display on form
        output.Text = "City: " + parseObj.City + vbCrLf
        output.Text = output.Text + "State: " + parseObj.State + vbCrLf
        output.Text = output.Text + "Zip: " + parseObj.Zip + vbCrLf
        output.Text = output.Text + "Plus4: " + parseObj.Plus4 + vbCrLf
End Sub
Private Sub initAddrObj()
            '***********Initializing ADDRESS CHECK Interface*************
        'Set License
        addrObj.SetLicenseString (dLICENSE)
        'Set path to the data files
        addrObj.PathToUSFiles = dFILELOC
        'addrObj.PathToCanadaFiles = dFILELOC
        'addrObj.PathToDPVDataFiles = dFILELOC
        'addrObj.PathToLACSLinkDataFiles = dFILELOC
        'addrObj.PathToRBDIFiles = dFILELOC
        'addrObj.PathToSuiteLinkDataFiles = dFILELOC
        'addrObj.PathToSuiteFinderDataFiles = dFILELOC

        'Now we will Initialize ourselves
        If (addrObj.InitializeDataFiles() <> 0) Then
            'If we were not successful then we need to return our error
            InitErrorString.Caption = addrObj.GetInitializeErrorString() + " "
        Else
            'Let's give them the good news
            InitErrorString.Caption = addrObj.GetInitializeErrorString() + " "
            'Let's get the US database date.
            DatabaseDate.Caption = addrObj.GetUSDatabaseDate()
            ExpDate.Caption = addrObj.GetUSExpirationDate()
            BuildNum.Caption = addrObj.GetBuildNumber()
        End If
End Sub
Private Sub initStreetObj()
        '****Initialize STREETDATA Interface****
        streetObj.SetLicenseString (dLICENSE)
        If (streetObj.Initialize(dFILELOC, dFILELOC, "")) Then
            ' Initialize failed
            InitErrorString.Caption = InitErrorString.Caption + streetObj.GetInitializeErrorString() + " "
        Else
            'Get information for form
            BuildNum.Caption = streetObj.GetBuildNumber()
            DatabaseDate.Caption = streetObj.GetDatabaseDate()
            InitErrorString.Caption = streetObj.GetInitializeErrorString()
        End If
End Sub
Private Sub initZipObj()
        '****Initialize ZIPDATA Interface****
        'Set License
        zipObj.SetLicenseString (dLICENSE)
        If zipObj.Initialize(dFILELOC, dFILELOC, "") Then
            ' Initialize failed
            InitErrorString.Caption = InitErrorString.Caption + zipObj.GetInitializeErrorString() + " "
        Else
            ' Initialize successful, get information for form
            BuildNum.Caption = zipObj.GetBuildNumber()
            DatabaseDate.Caption = zipObj.GetDatabaseDate()
            InitErrorString.Caption = zipObj.GetInitializeErrorString()
        End If
End Sub
Private Sub initParseObj()
        '****Initialize PARSE  Interface****
        '   Load Suffix File, not necessary but highly recommended
        '   Will increase parse accuracy with mispelled suffixes
        parseObj.Initialize (dFILELOC)
        BuildNum.Caption = parseObj.GetBuildNumber()
End Sub
Private Sub printParseProperties()
        cBuff = cBuff + "Range: " + parseObj.Range + vbCrLf
        cBuff = cBuff + "PostDirection: " + parseObj.PostDirection + vbCrLf
        cBuff = cBuff + "PreDirection: " + parseObj.PreDirection + vbCrLf
        cBuff = cBuff + "Suffix: " + parseObj.Suffix + vbCrLf
        cBuff = cBuff + "StreetName: " + parseObj.StreetName + vbCrLf
        cBuff = cBuff + "SuiteName: " + parseObj.SuiteName + vbCrLf
        cBuff = cBuff + "SuiteNumber: " + parseObj.SuiteNumber + vbCrLf
        cBuff = cBuff + "Garbage: " + parseObj.Garbage + vbCrLf
End Sub
Private Sub printZipProperties()
        cBuff = cBuff + zipObj.Zip + " "
        cBuff = cBuff + zipObj.City + " "
        cBuff = cBuff + zipObj.State + " "
        cBuff = cBuff + zipObj.AreaCode + " "
        cBuff = cBuff + zipObj.CountyFips + " "
        cBuff = cBuff + zipObj.CountyName + " "
        cBuff = cBuff + zipObj.Latitude + " "
        cBuff = cBuff + zipObj.Longitude + " "
        cBuff = cBuff + zipObj.LastLineIndicator + vbCrLf
End Sub
Private Sub printStreetProperties()
        cBuff = cBuff + streetObj.PrimaryRangeLow + "-"
        cBuff = cBuff + streetObj.PrimaryRangeHigh + " "
        cBuff = cBuff + streetObj.PrimaryRangeOddEven + " "
        cBuff = cBuff + streetObj.PreDirection + " "
        cBuff = cBuff + streetObj.StreetName + " "
        cBuff = cBuff + streetObj.Suffix + " "
        cBuff = cBuff + streetObj.PostDirection + " "
        If (streetObj.SuiteName = "") Then
            cBuff = cBuff + "    "
        Else
            cBuff = cBuff + streetObj.SuiteName + " "
        End If
        If (streetObj.SuiteRangeLow = "") Then
            cBuff = cBuff + "  "
        Else
            cBuff = cBuff + Trim(streetObj.SuiteRangeLow) + "-"
        End If
        If (streetObj.SuiteRangeHigh = "") Then
            cBuff = cBuff + "  "
        Else
            cBuff = cBuff + Trim(streetObj.SuiteRangeHigh) + " "
        End If
        cBuff = cBuff + streetObj.SuiteRangeOddEven + " "
        cBuff = cBuff + streetObj.Zip + " "
        cBuff = cBuff + streetObj.Plus4Low + "-"
        cBuff = cBuff + streetObj.Plus4High + vbCrLf
End Sub

